
import re
import numpy as np
import matplotlib.pyplot as plt
samples = []

def extract_numbers(string):
    numbers = re.findall(r'\d+', string)
    return [int(num) for num in numbers]

samples=[]
with open('output_.log') as myfile:
    for line in myfile.readlines():
        if re.search(r'MaxValueFnPlus EXPERT LEARNER SELECTION IDX', line):
            aa=(extract_numbers(line))
            print(aa[:aa[-1]])
            samples.append(aa[:aa[-1]])

idx_arr=[]
arm0=[]
arm1=[]
arm2=[]
learner=[]
counter=0
print(len(samples))
# exit()


for item in samples:
    print("counter",counter,"sum is", sum(item),"arr",item)

    item_tmp=np.array(item)
    # item_tmp2=item_tmp/np.sum(item_tmp)
    item_tmp2=item_tmp
    print(np.sum(item_tmp2))
    # total=sum(item)
    counter=counter+1
    if counter%2==0:
        continue
    idx_arr.append(counter/2)
    arm0.append(item_tmp2[0])
    arm1.append(item_tmp2[1])
    arm2.append(item_tmp2[2])
    learner.append(item_tmp2[3])

# exit()
fig, ax = plt.subplots()
idx_arr=np.array(idx_arr)
arm0 = np.array(arm0)
arm1 = np.array(arm1)
arm2 = np.array(arm2)
learner = np.array(learner)

snum=arm0+arm1+arm2+learner

# arm0=arm0/snum*100
# arm1=arm1/snum*100
# arm2=arm2/snum*100
# learner=learner/snum*100
#

arm0=arm0/snum
arm1=arm1/snum
arm2=arm2/snum
learner=learner/snum

width = 0.85
ax.bar(idx_arr, arm0,width=width,label="oracle 0")
ax.bar(idx_arr, arm1,width=width,bottom=arm0,label="oracle 1")
ax.bar(idx_arr, arm2,width=width,bottom= arm0+ arm1, label="oracle 2")
ax.bar(idx_arr, learner,width=width,bottom= arm0+ arm1+ arm2, label="learner")

# ax.set_fontsize(20)
plt.rcParams.update({'font.size': 12})

plt.ylabel("Freq. of expert selection", fontsize=18)
plt.xlabel("Training steps", fontsize=25)

plt.legend(loc='lower left', ncol=1, borderaxespad=3)
plt.savefig('imitate_reinforce.pdf',bbox_inches='tight')


plt.show()

